<?php
/**************************************************************************\
 * Programma scritto da Guido Volpi <tamerlo@gattonerong.it>              *
 * Software released under the terms of  GPL v 2.0 license                *
\**************************************************************************/

// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //


# introduzione
include '../../../include/cp_header.php';

include "../include/functions.php";
include_once XOOPS_ROOT_PATH."/class/module.errorhandler.php";

# header
xoops_cp_header();

# raccolta informazioni generali
$utable = $xoopsDB->prefix("users");
$vtable = $xoopsDB->prefix("buoniecattivi_voti");

# funzione per la ripulitura del testo ad evitare 
# l'iniezione di codice e per l'aggiunta di emoticons
function PulisciMotivo($text) {
	$myts =& MyTextSanitizer::getInstance();
	$text = $myts->stripSlashesGPC($text);
	$text = $myts->htmlSpecialChars($text);	
	$text = $myts->smiley($text);	
	return $text;
}

if (isset($_GET['del']) || isset($_POST['del'])) {
	if ( isset($_POST['ok']) ) {
		$delok = $_GET['ok'] ? $_GET['ok'] : $_POST['ok'];
	}
	
	if ( $delok ) {
		$del = $_GET['del'] ? $_GET['del'] : $_POST['del'];
		$query = "delete from $vtable where idvoto=$del";
		$res = $xoopsDB->query($query);
		echo "<div class=\"odd\">";
		if ( $res ) {
			echo "<p>"._MI_AD_REMOVED."</p>";
			echo "<p><a href=\"index.php\">"._MI_AD_GOINDEX."</a>";
		}
		else {
			echo "<p>"._MI_AD_NOTREMOVED."</p>";
			echo "<p> query: $query<br/>Errore: ".$xoopsDB->error()."</p>";
		}
		echo "</div>";
	}
	else {
		echo "<h4>"._MI_AD_VOTEDEL_TITLE."</h4>";
		xoops_confirm( array('del' => $_GET['del'], 'ok' => 1 ), "index.php", _MI_AD_VOTEDEL_Q);
	}
}
else if ( isset($_GET['mod']) || isset($_POST['mod'])) {
?>

<div class="odd" width="100%">
<h4>Modifica il voto</h4>
<?php
	# aquisisce l'indice del voto
	$idvoto = isset($_GET['mod']) ? $_GET['mod'] : $_POST['mod'];
	//$idvoto = intval(stripslashes($_POST['mod']));
	
	if (isset($_POST['ok'])) {
		$okmod = isset($_POST['ok']) ? $_POST['ok'] : $_GET['ok'];
		switch ($okmod) {
			case 0:
			xoops_confirm( array('mod' => $_GET['mod'], 'ok' => 1, 'motivo' => $_POST['motivo']),
				"index.php", _MI_AD_MODIFY_Q);
			break;
			
			case 1:
			$idvoto = $_POST['mod'];
			$motivo = $xoopsDB->quoteString(stripslashes($HTTP_POST_VARS['motivo']));
			$query = "update $vtable set motivo=$motivo where idvoto=$idvoto";
			echo "<div class=\"odd\">";
			$result = $xoopsDB->query($query);
			if ( $result ) {
				echo "<p>"._MI_AD_MODIFIED."</p>";
				echo "<p><a href=\"index.php\">"._MI_AD_GOINDEX."</a>";
			}
			else {
				echo "<p>"._MI_AD_NOTMODIFIED."</p>";
				echo "<p> query: $query<br/>Errore: ".$xoopsDB->error()."</p>";
			}
			echo "</div>";
			break;
		}
	}
	else {
		# search vote
		$query = "select uname,come,motivo from $vtable,$utable where idvoto=$idvoto and $vtable.uid=$utable.uid";
		$result = $xoopsDB->query($query);
		if ($result) {
			$userdata = $xoopsDB->fetchArray($result);
			if ($userdata['come'] == 1) {
				$userdata['come'] = _MI_GOOD;
			}
			else if ($userdata['come'] == 2) {
				$userdata['come'] = _MI_BAD;
			}
			echo "<form action=\"?mod=$idvoto\" method=\"post\">";
			echo "<input type=\"hidden\" name=\"ok\" value=\"0\">";
			echo "<p><b>".$userdata['uname']."</b>  <b>".$userdata['come']."</b>, motivo:<br/> <textarea name=\"motivo\" cols=\"40\" rows=\"5\" >".stripslashes($userdata['motivo'])."</textarea><br/>\n";
			echo "<input type=\"submit\" value=\"Modifica il voto\"> </p>";
			echo "<p><a href=\"index.php\">Ritorna all'amministrazione del modulo</a></p>";
			echo "</form>";
		}
		else {
			echo "<p>Voto non trovato</p>";
		}
	}
?>
</div>
<?php
}
else {	
	# amministrazione vera e propria
	echo "<h3>"._MI_AD_TITLE."</h3>\n";
?>
<div class="odd" width="100%">
<h4>Lista dei voti</h4>
<table border="1" width="100%">
<thead>
<?php
echo "<tr><th>"._MI_AD_DATE."</th><th>"._MI_AD_USER."</th><th>"._MI_AD_HOW."</th><th>"._MI_AD_WHY."</th><th>&nbsp;</th></tr>";
?>
</thead>
<tbody>
<?php
	# raccoglie l'elenco dei voti
	$from = 0;
	if (isset($_GET['from'])) {
		$from= intval($_GET['from']);
	}
	$result = $xoopsDB->query("select idvoto, from_unixtime(time,'%d-%m-%Y') as data,uname,come,motivo from $vtable,$utable where $vtable.uid=$utable.uid order by $vtable.idvoto desc limit $from,15");
	while ( ($userdata = $xoopsDB->fetchArray($result)) ) {
		if ($userdata['come'] == 1) {
			$userdata['come'] = _MI_GOOD;
		}
		else if ($userdata['come'] == 2) {
			$userdata['come'] = _MI_BAD;
		}
		echo "<tr>";
		echo "<td>".$userdata['data']."</td>";
		echo "<td>".$userdata['uname']."</td>";
		echo "<td>".$userdata['come']."</td>";
		echo "<td>".PulisciMotivo($userdata['motivo'])."</td>";
		echo "<td> <a href=\"?mod=".$userdata['idvoto']."\">"._MI_AD_MODIFY."</a> <a href=\"?del=".$userdata['idvoto']."\">"._MI_AD_REMOVE."</a></td></tr>";
	}
?>
</tbody>
</table>
<p align="center">
<?php
	$result = $xoopsDB->query("select count(*) from $vtable");
	$ndata = $xoopsDB->FetchRow($result);
		
	if ($from>0) {
		$offmin = $from > 14 ? $from - 15 : 0;
		echo "<a href=\"?from=".$offmin."\">&lt;&lt;</a>";
	}
 	if ($ndata[0]>$from+14) {
		echo "<a href=\"?from=".($from+15)."\">&gt;&gt;</a>";
	}
}
?>
</p>
</div>
<?php

# end of page
xoops_cp_footer();
?>