<?php
/**************************************************************************\
 * Programma scritto da Guido Volpi <tamerlo@gattonerong.it>              *
 * Software released under the terms of  GPL v 2.0 license                *
\**************************************************************************/

// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //


include './header.php';
include XOOPS_ROOT_PATH.'/header.php';
include XOOPS_ROOT_PATH.'/class/xoopsformloader.php';
include'./class/formdhtmltextarea_custom.php';
$myts =& MyTextSanitizer::getInstance();

$commento = "";

# funzione per la ripulitura del testo ad evitare 
# l'iniezione di codice e per l'aggiunta di emoticons
function PulisciMotivo($text) {
	global $myts;
	$text = $myts->stripSlashesGPC($text);
	$text = $myts->htmlSpecialChars($text);	
	$text = $myts->smiley($text);
	return $text;
	//return $myts->displayTarea($text,0,1,0,0,0);
}

# termini di traduzione per i template
$lang = array('buoni' => _MI_GOODS, 'cattivi' => _MI_BADS, 'buono' => _MI_GOOD, 'cattivo' => _MI_BAD, 'date' => _MI_DATE, 'user' => _MI_USER, 'how' => _MI_HOW, 'why' => _MI_WHY, 'form_user' => _MI_FORM_USER, 'form_how' => _MI_FORM_HOW, 'form_why' => _MI_FORM_WHY);
$xoopsTpl->assign('lang',$lang);

# raccolta lista degli utenti da processare
$table = $xoopsDB->prefix("users");
$myusers = array();
$result = $xoopsDB->query("select uid,uname from $table where level > 0 order by uname");
while ( ($userdata = $xoopsDB->fetchArray($result)) ) {
	$myusers[] = $userdata;
}
$xoopsDB->freeRecordSet($result);

# racoglie informazione sll'operazione da compiere
$op = "";
if (isset($_GET['op'])) {
	$op = $_GET['op'];
}

# controlla se deve registrare un voto
if ($op == "vote") {
	# controllo per l'utente registrato
	if ($xoopsUser) {
		# raccola dei dati
		$ctrl = 0;
		$chi = $_POST['personaggio'];
		# controlla l'esistenza del votato
		foreach($myusers as $tmpu) {
			if ($tmpu['uid'] == $chi) {	
				$come = $_POST['come'];
				if ( $_POST['motivo'] ) {
					$motivo = $xoopsDB->quoteString($_POST['motivo']);
					$oggi = date("Y/m/d");
					$ora = time();
					$table = $xoopsDB->prefix("buoniecattivi_voti");
					$res = $xoopsDB->query("insert into $table(uid,come,motivo,time,ipvoto) values ($chi,$come,$motivo,'$ora',\"".$_SERVER['REMOTE_ADDR']."\")");
					if ($res == 1) {
						$commento = "Voto a ".$tmpu['uname']." registrato $oggi";
						$ctrl = 1;
					}
					break;
				}
				else {
					$commento = "Manca un motivo valido";
					$ctrl = 1;
				}
			}
		}
		if ($ctrl==0) {
			$commento = "Registrazione del voto fallita, ricontrolla i dati inseriti";
		}
	}
	else {
		$commento = "Voto non accettato, per votare devi essere registrato";
	}
}

$buoni = array();
$cattivi = array();
$voti = array();
# controlla il tipo di pagina da visualizzare
if ($op=="log") {
	$xoopsOption['template_main'] = "bc_log.html";
	$utable = $xoopsDB->prefix("users");
	$vtable = $xoopsDB->prefix("buoniecattivi_voti");
	# raccoglie l'offset ed il numero totale dei voti
	if (isset($_GET['from'])) {
		$from= intval($_GET['from']);
	}
	else {
		$from = 0;
	}
	$result = $xoopsDB->query("select from_unixtime(time,'%d-%m-%Y') as data,uname,come,motivo from $vtable,$utable where $vtable.uid=$utable.uid order by $vtable.idvoto desc limit $from,30");
	while ( ($userdata = $xoopsDB->fetchArray($result)) ) {
		if ($userdata['come'] == 1) {
			$userdata['come'] = _MI_GOOD;
		}
		else if ($userdata['come'] == 2) {
			$userdata['come'] = _MI_BAD;
		}
		else {
			continue;
		}
		$userdata['motivo'] = PulisciMotivo($userdata['motivo']);
		
		$voti[] = $userdata;
	}
	$xoopsDB->freeRecordSet($result);
	# raccoglie il numero totale degli inserimenti
	$result = $xoopsDB->query("select count(*) from $vtable");
	$userdata = $xoopsDB->fetchRow($result);
	$totvoti = $userdata[0];
	if ($from>0) {
		$offmin = $from > 29 ? $from - 30 : 0;
		$previous = "<a href=\"?op=log&from=".$offmin."\" title=\""._MI_LOG_PREV."\">&lt;&lt;</a>";
	}
	else {
		$previous = "&lt;&lt;";
	}
 	if ($totvoti>=$from+30) {
		$next = "<a href=\"?op=log&from=".($from+30)."\" title=\""._MI_LOG_NEXT."\">&gt;&gt;</a>";
	}
	else {
		$next = "&gt;&gt;";
	}
}
else {
	# template di base
	$xoopsOption['template_main'] = "bc_index.html";
	#raccolta dei buoni e cattivi
	$utable = $xoopsDB->prefix("users");
	$vtable = $xoopsDB->prefix("buoniecattivi_voti");
	
	# raccoglie gli ultimi 4
	$ultimi = array();
	$result = $xoopsDB->query("select uid,max(idvoto) as mid from xoops_buoniecattivi_voti group by uid order by mid desc limit 4");
	while ( ($userdata = $xoopsDB->fetchArray($result)) ) {
		$ultimi[] = $userdata;
	}
	
	foreach($myusers as $tmpu) {
		# don't show votes older than...
		$cval = $xoopsModuleConfig['oldest'];
		$timelimit = time()-$cval*3600*24;
		$result = $xoopsDB->query("select $utable.uid,uname,come,motivo from $vtable,$utable where $utable.uid=$vtable.uid and $utable.uid=".$tmpu['uid']." and time > \"$timelimit\" order by idvoto desc limit 1");
		if ($result) {
			$userdata = $xoopsDB->fetchArray($result);
			# sostituzioni di simboli nel testo
			$userdata['motivo'] = PulisciMotivo($userdata['motivo']);
			
			# controlla se fa parte degli ultimi
			for ($i=0;$i<count($ultimi);$i++) {
				if ($userdata['uid']==$ultimi[$i]['uid']) {
					$userdata['last'] = 1;
				}
			}
			if ($userdata['come'] == 1 ) {
				$buoni[] = $userdata;
			}
			else if ($userdata['come'] == 2) {
				$cattivi[] = $userdata;
			}
		}
		$xoopsDB->freeRecordSet($result);
	}
}

# cosi passo variabili a smart che riprendo con <{$va}>
# $xoopsTpl->assign('uname', $uname); 
if ($op == "log") {
	$xoopsTpl->assign('estremi',array('from' => $from+1, 'to' => $from+count($voti) ));
	$xoopsTpl->assign('voti',$voti);
	$xoopsTpl->assign('previous',$previous);
	$xoopsTpl->assign('next',$next);
}
else {
	$xoopsTpl->assign('users',$myusers);
	$xoopsTpl->assign('buoni',$buoni);
	$xoopsTpl->assign('cattivi',$cattivi);
	$xoopsTpl->assign('comment',$commento);
	$xoopsTpl->assign('vislog',_MI_VIS_LOG);
	$voteform = new XoopsThemeForm("Vota un iscritto","form_vote","?op=vote");
	$voteform->addElement(new XoopsFormSelectUser(_MI_USER,"personaggio"));
	$selwhy = new XoopsFormSelect("Come","come");
	$selwhy->addOption(1,_MI_GOOD);
	$selwhy->addOption(2,_MI_BAD);
	$voteform->addElement($selwhy);
	//$voteform->addElement(new XoopsFormText(_MI_HOW, 'motivo', 60, 100), true);
        $txtarea = new XoopsFormDhtmlTextAreaCustom(_MI_HOW,'motivo','',5,60);
        $txtarea->setToolbar(false);
        $txtarea->setSmileys(true);
        $voteform->addElement($txtarea, true);
	$btray = new XoopsFormElementTray('',"&nbsp;");
	$btray->addElement(new XoopsFormButton('',"submit",_MI_SUBMIT,"submit"));
	$btray->addElement(new XoopsFormButton('',"reset",_MI_RESET,"reset"));
	$voteform->addElement($btray);
	$voteform_html = $voteform->render();
	$xoopsTpl->assign('voteform',$voteform_html);
	$xoopsTpl->assign('disclaimer',$xoopsModuleConfig['disclaimer']);
}

$xoopsTpl->assign("xoops_module_header",'<link rel="stylesheet" type="text/css" href="bcstyle.css" />');
include_once XOOPS_ROOT_PATH.'/footer.php';
?>
